# Generated Python Strategy for: PlayerB (meta)
# Run Index: 10
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerB_DeepSeek_V3_MetaAgent_Run10_Iter1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # First round: Cooperate by default
    if not my_history:
        return "C"
    
    # Heuristic analysis of opponent's code
    opponent_code = opponent_program_code.lower()
    
    # Check for always_cooperate or similar patterns
    always_cooperate_keywords = ["always_cooperate", "return 'c'", "return c", "always c"]
    if any(keyword in opponent_code for keyword in always_cooperate_keywords):
        return "C"
    
    # Check for always_defect or similar patterns
    always_defect_keywords = ["always_defect", "return 'd'", "return d", "always d"]
    if any(keyword in opponent_code for keyword in always_defect_keywords):
        return "D"
    
    # Check for Tit-for-Tat-like patterns (e.g., returning last move)
    tit_for_tat_keywords = ["opp_history[-1]", "opp_history[len(opp_history)-1]", "return opp_history[-1]"]
    if any(keyword in opponent_code for keyword in tit_for_tat_keywords):
        return opp_history[-1] if opp_history else "C"
    
    # Check for random behavior
    random_keywords = ["random.choice", "random.randint", "random.random"]
    if any(keyword in opponent_code for keyword in random_keywords):
        return "D"  # Defect against random strategies
    
    # Check for self-referential or similar logic (potential meta-agent)
    self_referential_keywords = ["opponent_program_code", "make_internal_llm_call"]
    if any(keyword in opponent_code for keyword in self_referential_keywords):
        return "D"  # Be cautious against meta-agents
    
    # Check for code length heuristic (short code may imply simple strategy)
    lines = opponent_program_code.split('\n')
    non_empty_lines = [line.strip() for line in lines if line.strip()]
    if len(non_empty_lines) < 5:
        return "C"  # Cooperate with simple strategies
    
    # Default to Tit-for-Tat if no clear heuristic matches
    return opp_history[-1] if opp_history else "C"